<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'Open the database.

   call OpenDB()

   'Default to current week if no valid number was given.

   week = Request("week")
   if not IsNumeric(week) then
     week = CurrentWeek()
   else
     week = Round(week)
     if week < 1 or week > NumberOfWeeks() then
       week = CurrentWeek()
     end if
   end if

  'Find the number of games for this week.

   n = NumberOfGames(week)

   if NumberOfUsers() = 0 then
     call ErrorMessage("No users found in database.")
   else %>

<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr>
  <th>Name</th>
  <th colspan=<% = n %> style="text-align:center;">Week <% = week %></th>
  <th colspan=2>TB</th>
  <th colspan=2>Score</th>
</tr>
<%   'List one user per row.

     sql = "select *" _
        & " from Users" _
        & " where Username <> '" & ADMIN_USERNAME & "'" _
        & " order by Username"
     set rs = DbConn.Execute(sql)
     if not (rs.BOF and rs.EOF) then
       i = 0
       rs.MoveFirst
       do while not rs.EOF
         username = rs.Fields("Username").Value
         if Round(i / 2) * 2 = i then %>
<tr>
<%       else %>
<tr class="alt">
<%       end if
         i = i + 1 %>
  <td><% = username %></td>
<%       'Display picks for this user, highlight any correct ones.

         total = 0
         sql = "select *" _
            & " from Picks, Schedule" _
            & " where Username = '" & rs.Fields("Username").Value & "'" _
            & " and Week = " & week _
            & " and Picks.GameID = Schedule.GameID" _
            & " order by Schedule.Date, Schedule.Time, Schedule.GameID"
         set rs2 = DbConn.Execute(sql)
         if not (rs2.BOF and rs2.EOF) then
           do while not rs2.EOF
             pick = rs2.Fields("Pick").Value
             result = rs2.Fields("Result").Value
             if pick = "" then
               pick = "---"
             end if
             if pick = result then
               pick = "<b>" & pick & "</b>"
             end if
             if result <> "" then
               total = total + 1
             end if %> 
  <td><% = pick %></td>
<%           rs2.MoveNext %>
<%         loop

           'Display score and tie breaker data for this user.

           tbGuess = UserTBGuess(username, week)
           tbActual = TBPointTotal(week)
           if IsNumeric(tbActual) and IsNumeric(tbGuess) then
             tbDiff = "(" & Abs(tbActual - tbGuess) & ")"
           else
             tbDiff = ""
           end if
           score = UserScore(username, week)
           if total <> 0 then
             scoreStr = score & "/" & total
             pct = "(" & FormatPercent(score / total) & ")"
           else
             scoreStr = "n/a"
             pct = ""
           end if %>
  <td align=right><% = tbGuess %></td>
  <td align=right><% = tbDiff %>&nbsp;</td>
  <td align=right><% = scoreStr %>&nbsp;</td>
  <td align=right><% = pct %>&nbsp;</td>

<%       'User has no entries for this week, fill with blanks.

         else
           for j = 1 to n %>
  <td>---</td>
<%         next %>
  <td>---</td>
  <td>&nbsp;</td>
  <td align=right>n/a&nbsp;</td>
  <td>&nbsp;</td>
<%         end if %>
</tr>
<%       rs.MoveNext
       loop

       'If the week has been concluded, display the winners.

       str = ""
       list = WinnersList(week)
       if IsArray(list) then
         for i = 0 to UBound(list)
           if i > 0 then
             str = str & ", "
           end if
           str = str & list(i)
         next %>
<tr><th colspan=<% = n + 5 %>>Winner: <% = str %></th></tr>
<%     end if
     end if %>
</table></p>

<% 'List weeks. %>

<p><b>Go to week:</b>
<%   for i = 1 to NumberOfWeeks() %>
<a href="<% = Request.ServerVariables("SCRIPT_NAME") %>?week=<% = i %>">
<% = i %></a>&nbsp;
<%   next %>
</p>
<% end if %>


<!-- #include file="footer.inc" -->
